#include <QCoreApplication>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
    #include "usblismpi26.h"
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    qint32 err;
    uint16_t val16;

    setbuf(stdout, NULL);
    printf("\n\n******* USB LISM-PI26xx - Open and Close Device *******\n\n");

    ls_initialize(1024*1024, 4096);

    if (ls_enumdevices() == 0) {
        printf("No devices available.\n");
        return 1;
    }
    printf("Number of devices available: %d\n", ls_enumdevices());

    // Open device with index = 0
    printf("Open device: ");
    err = ls_opendevicebyindex(0);
    if (err == RET_OK) {
        //Read device information

        printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
        printf("%s\n",ls_getserialnumber(ls_currentdeviceindex()));

        val16 = ls_getfwversion(0);
        printf("USB Version: %d.%d\n",((val16 >> 8) & 0x00FF),(val16 & 0x00FF));

        printf("MCU Version: ");
        err = ls_getmcuversion(LISM_ADDR, val16,1000);
        if (err == RET_OK)
            printf("%d.%d\n",((val16 >> 8) & 0x00FF),(val16 & 0x00FF));
        else
            printf("ERROR: %s\n", ls_geterrorstring(err));

        printf("CTG Version: ");
        err = ls_getctgversion(LISM_ADDR, val16,1000);
        if (err == RET_OK)
            printf("%d.%d\n",((val16 >> 8) & 0x00FF),(val16 & 0x00FF));
        else
            printf("ERROR: %s\n", ls_geterrorstring(err));

        printf("HW1 ID: ");
        err = ls_gethw1id(LISM_ADDR, val16,1000);
        if (err == RET_OK)
            printf("     %x\n",val16);
        else
            printf("ERROR: %s\n", ls_geterrorstring(err));

        printf("HW1 Version: ");
        err = ls_gethw1version(LISM_ADDR, val16,1000);
        if (err == RET_OK)
            printf("%d.%d\n",((val16 >> 8) & 0x00FF),(val16 & 0x00FF));
        else
            printf("ERROR: %s\n", ls_geterrorstring(err));

        printf("HW2 Version: ");
        err = ls_gethw2version(LISM_ADDR, val16,1000);
        if (err == RET_OK)
            printf("%d.%d\n",((val16 >> 8) & 0x00FF),(val16 & 0x00FF));
        else
            printf("ERROR: %s\n", ls_geterrorstring(err));

        // Close device
        ls_closedevice();
        printf("Device closed\n");
    }
    else {
        printf("%s",ls_geterrorstring(err));
    }
    return 0;
}
