#include <QCoreApplication>
#include <cmath>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
    #include "usblismpi26.h"
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    quint32 uval32;
    quint8  uval8;
    qint32  err;

    setbuf(stdout, NULL);
    printf("\n\n******* USB LISM-PI26xx - Trigger Output *******\n\n");

    ls_initialize(1024*1024,4096);

    if (ls_enumdevices() == 0) {
        printf("No devices available.\n");
        return 1;
    }
    printf("Number of devices available: %d\n", ls_enumdevices());

    // Open device with index = 0
    printf("Open device: ");
    err = ls_opendevicebyindex(0);
    if (err == RET_OK) {
        printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
        printf("%s\n\n",ls_getserialnumber(ls_currentdeviceindex()));

        printf("Get IF Config: ");
        err = ls_getifconfig(LISM_ADDR, uval8, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("0x%x\n",uval8);
            printf("Clear Bit[6] => IF_TRIGGER_OUTPUT_HIGH\n");
            uval8 &= ~0x40; // Clear Bit[6] => IF_TRIGGER_OUTPUT_HIGH
            printf("Set Trigger Output to High-Active: ");
            err = ls_setifconfig(LISM_ADDR, uval8, 1000);
            if (err == RET_OK) {
                printf("0x%x\n",uval8);
            } else {
                printf("ERROR: %s\n",ls_geterrorstring(err));
            }
        }

        uval32 = 250;
        printf("Set Trigger Delay: ");
        err = ls_settriggerdelay(LISM_ADDR, uval32, 1000);
        if (err == RET_OK) {
            printf("%d us\n", uval32);
        } else {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        }

        uval32 = 1000;
        printf("Set Trigger Width: ");
        err = ls_settriggerwidth(LISM_ADDR, uval32, 1000);
        if (err == RET_OK) {
            printf("%d us\n",uval32);
        } else {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        }

        printf("Get Trigger Delay: ");
        err = ls_gettriggerdelay(LISM_ADDR, uval32, 1000);
        if (err == RET_OK) {
            printf("%d us\n",uval32);
        } else {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        }
        printf("Get Trigger Width: ");
        err = ls_gettriggerwidth(LISM_ADDR, uval32, 1000);
        if (err == RET_OK) {
            printf("%d us\n",uval32);
        } else {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        }

        // Close device
        ls_closedevice();
        printf("\nDevice closed\n");
    } else {
        printf("ERROR: %s\n",ls_geterrorstring(err));
    }

    return 0;
}
