#include <QCoreApplication>
#include <cmath>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
    #include "usblismpi26.h"
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    quint8 IfConfig;
    qint32 err;

    setbuf(stdout, NULL);
    printf("\n\n******* USB LISM-PI26xx - IF Config *******\n\n");

    ls_initialize(1024*1024,4096);

    if (ls_enumdevices() == 0) {
        printf("No devices available.\n");
        return 1;
    }
    printf("Number of devices available: %d\n",ls_devicecount());

    // Open device with index = 0
    printf("Open device: ");
    err = ls_opendevicebyindex(0);
    if (err == RET_OK) {
        printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
        printf("%s\n\n",ls_getserialnumber(ls_currentdeviceindex()));

        IfConfig =	IF_DCLK_20MHZ |
                    IF_DCLK_POL_RISING_EDGE |
                    IF_LINE_VALID_HIGH |
                    IF_FRAME_VALID_HIGH |
                    IF_TRIGGER_OUTPUT_LOW;

        printf("Set IF Config: ");
        err = ls_setifconfig(LISM_ADDR, IfConfig, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("0x%x\n",IfConfig);
        }

        printf("Get IF Config: ");
        err = ls_getifconfig(LISM_ADDR, IfConfig, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("0x%x\n",IfConfig);

            switch (IfConfig & 0x07) {
            case 0x00: printf("Data Clock = 400 kHz\n"); break;
            case 0x01: printf("Data Clock = 500 kHz\n"); break;
            case 0x02: printf("Data Clock = 800 kHz\n"); break;
            case 0x03: printf("Data Clock = 1 MHz\n"); break;
            case 0x04: printf("Data Clock = 2 MHz\n"); break;
            case 0x05: printf("Data Clock = 4 MHz\n"); break;
            case 0x06: printf("Data Clock = 10 MHz\n"); break;
            case 0x07: printf("Data Clock = 20 MHz\n"); break;
            }

            if ((IfConfig & IF_DCLK_POL_FALLING_EDGE) == IF_DCLK_POL_FALLING_EDGE) {
                printf("Data Clock Polarity: Falling Edge\n");
            } else {
                printf("Data Clock Polarity: Rising Edge\n");
            }

            if ((IfConfig & IF_LINE_VALID_LOW) == IF_LINE_VALID_LOW) {
                printf("Line Valid Polarity: Low Active\n");
            } else {
                printf("Line Valid Polarity: High Active\n");
            }

            if (IfConfig & IF_FRAME_VALID_LOW) {
                printf("Frame Valid Polarity: Low Active\n");
            } else {
                printf("Frame Valid Polarity: High Active\n");
            }

            if (IfConfig & IF_TRIGGER_OUTPUT_LOW) {
                printf("Trigger Output Polarity: Low Active\n");
            } else {
                printf("Trigger Output Polarity: High Active\n");
            }
        }


        // Close device
        ls_closedevice();
        printf("\nDevice closed\n");
    } else {
        printf("ERROR: %s\n",ls_geterrorstring(err));
    }

    return 0;
}
