#include <QCoreApplication>
#include <cmath>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
    #include "usblismpi26.h"
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    quint8  cfg;
    qint32 err;
    quint32 qcnt;

    setbuf(stdout, NULL);
    printf("\n\n******* USB LISM-PI26xx - Mode Config *******\n\n");

    ls_initialize(1024*1024,4096);

    if (ls_enumdevices() == 0) {
        printf("No devices available.\n");
        return 1;
    }
    printf("Number of devices available: %d\n", ls_enumdevices());

    // Open device with index = 0
    printf("Open device: ");
    err = ls_opendevicebyindex(0);
    if (err == RET_OK) {
        printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
        printf("%s\n\n",ls_getserialnumber(ls_currentdeviceindex()));

        cfg = MODE_QUAD_ENC_TRIGGER |
              MODE_ENCODER_DIR_CCW  |
              MODE_ENCODER_CNT_ENABLE;

        printf("Set Mode Config:   ");
        err = ls_setmodeconfig(LISM_ADDR, cfg, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("0x%x\n",cfg);
        }

        qcnt = 4;
        printf("Set Quad Count:    ");
        err = ls_setquadcount(LISM_ADDR, qcnt, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("%d\n",qcnt);
        }

        printf("Get Mode Config:   ");
        err = ls_getmodeconfig(LISM_ADDR, cfg, 1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("0x%x\n\n",cfg);

            printf("Trigger mode:      ");
            switch (cfg & 0x07) {
            case 0x00: printf("Free running\n"); break;
            case 0x01: printf("Ext rising edge (SL)\n"); break;
            case 0x02: printf("Ext high level\n"); break;
            case 0x03: printf("Internal soft trigger\n"); break;
            case 0x04: printf("Quadrature encoder trigger\n"); break;
            case 0x05: printf("Ext rising edge (ML)\n"); break;
            default: printf("Unknown 0x%x\n",(cfg & 0x07));
            }

            if ((cfg & MODE_ENCODER_DIR_CCW) == MODE_ENCODER_DIR_CCW) {
                printf("Encoder direction: CCW (DOWN)\n");
            } else {
                printf("Encoder direction: CW (UP)\n");
            }

            if ((cfg & MODE_ENCODER_CNT_ENABLE) == MODE_ENCODER_CNT_ENABLE) {
                printf("Encoder counter:   Enabled\n");
            } else {
                printf("Encoder counter:   Enabled\n");
            }

             if ((cfg & 0x07) == 0x04) {
                 printf("Quad Count:        ");
                 err = ls_getquadcount(LISM_ADDR, qcnt, 1000);
                 if (err != RET_OK) {
                    printf("ERROR: %s\n",ls_geterrorstring(err));
                 } else {
                    printf("%d\n",qcnt);
                 }
             }
        }
        // Close device
        ls_closedevice();
        printf("\nDevice closed\n");
    } else {
        printf("ERROR: %s\n",ls_geterrorstring(err));
    }
    return 0;
}
