#include <QCoreApplication>
#include <cmath>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern "C"
{
    #include "usblismpi26.h"
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    qint32 val32;
    qint32 err;

    setbuf(stdout, NULL);
    printf("\n\n******* USB LISM-PI26xx - PacketLength *******\n\n");

    ls_initialize(1024*1024,4096);

    if (ls_enumdevices() == 0) {
        printf("No devices available.\n");
        return 1;
    }
    printf("Number of devices available: %d\n", ls_enumdevices());

    // Open device with index = 0
    printf("Open device: ");
    err = ls_opendevicebyindex(0);
    if (err == RET_OK) {
        printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
        printf("%s\n\n",ls_getserialnumber(ls_currentdeviceindex()));

        printf("Get PacketLength (Device): ");
        err = ls_getpacketlength(val32,1000);
        if (err != RET_OK) {
            printf("ERROR: %s\n",ls_geterrorstring(err));
        } else {
            printf("%d Bytes\n",val32);
            printf("Close device to set USB PacketLength\n");
            ls_closedevice();
            val32 *= 4; // USB PacketLength can be multiple of device's PacketLength (1, 2, 3, 4,...)
            printf("Set PacketLength (USB): ");
            err = ls_setpacketlength(val32);
            if (err != RET_OK) {
                printf("ERROR: %s\n",ls_geterrorstring(err));
            } else {
                printf("%d Bytes\n",val32);

                printf("(Re)Open device: ");
                if (ls_opendevicebyindex(0) == RET_OK) {
                    printf("%s - ",ls_getproductname(ls_currentdeviceindex()));
                    printf("%s\n\n",ls_getserialnumber(ls_currentdeviceindex()));
                    printf("Device ready for use..\n\n");
                } else {
                    printf("ERROR: %s\n",ls_geterrorstring(err));
                }
            }
        }

        if (ls_currentdeviceindex() > -1 ) {
            // Close device
            ls_closedevice();
            printf("\nDevice closed\n");
        }
    } else {
        printf("ERROR: %s\n",ls_geterrorstring(err));
    }

    return 0;
}
