#ifndef USBLISMPI26_H
#define USBLISMPI26_H

#include <QtCore/qglobal.h>

#ifdef __cplusplus
 extern "C" {            /* Assume C declarations for C++ */
#endif

 //------ Constants ------
 #define LISM_ADDR       0xFE
 #define RET_OK          0x00000000

 #define _512            512u
 #define _1kB            (_512 * 2u)
 #define _2kB            (_1kB * 2u)
 #define _4kB            (_2kB * 2u)
 #define _8kB            (_4kB * 2u)
 #define _16kB           (_8kB * 2u)
 #define _32kB           (_16kB * 2u)
 #define _64kB           (_32kB * 2u)
 #define _128kB          (_64kB * 2u)
 #define _256kB          (_128kB * 2u)
 #define _512kB          (_256kB * 2u)
 #define _1MB            (_512kB * 2u)
 #define _2MB            (_1MB * 2u)
 #define _4MB            (_2MB * 2u)
 #define _8MB            (_4MB * 2u)
 #define _16MB           (_8MB * 2u)
 #define _32MB           (_16MB * 2u)
 #define _64MB           (_32MB * 2u)
 #define _128MB          (_64MB * 2u)
 #define _256MB          (_128MB * 2u)

 #define _1ms            1u
 #define _1s             (1000u * _1ms)

 #define MODE_FREE_RUNNING           0x00
 #define MODE_EXT_RISING_EDGE_SL     0x01
 #define MODE_EXT_HIGH_LEVEL         0x02
 #define MODE_INT_SOFT_TRIGGER       0x03
 #define MODE_QUAD_ENC_TRIGGER       0x04
 #define MODE_EXT_RISING_EDGE_ML     0x05
 #define MODE_ENCODER_DIR_CW         0x00
 #define MODE_ENCODER_DIR_CCW        0x10
 #define MODE_ENCODER_CNT_DISABLE    0x00
 #define MODE_ENCODER_CNT_ENABLE     0x20

 #define IF_DCLK_400KHZ              0x00
 #define IF_DCLK_500KHZ              0x01
 #define IF_DCLK_800KHZ              0x02
 #define IF_DCLK_1MHZ                0x03
 #define IF_DCLK_2MHZ                0x04
 #define IF_DCLK_4MHZ                0x05
 #define IF_DCLK_10MHZ               0x06
 #define IF_DCLK_20MHZ               0x07
 #define IF_DCLK_POL_RISING_EDGE     0x00
 #define IF_DCLK_POL_FALLING_EDGE    0x08
 #define IF_LINE_VALID_HIGH          0x00
 #define IF_LINE_VALID_LOW           0x10
 #define IF_FRAME_VALID_HIGH         0x00
 #define IF_FRAME_VALID_LOW          0x20
 #define IF_TRIGGER_OUTPUT_HIGH      0x00
 #define IF_TRIGGER_OUTPUT_LOW       0x40

 #define ADC_VREF_1V6                0x00
 #define ADC_VREF_2V0                0x01

 quint16 ls_libversion();

 void ls_initialize(qint32 pipesize, qint32 packetlen);
 qint32 ls_enumdevices();
 quint16 ls_getfwversion(qint32 index);
 const char* ls_getvendorname(qint32 index);
 const char* ls_getproductname(qint32 index);
 const char* ls_getserialnumber(qint32 index);
 quint8 ls_devicecount();
 qint32 ls_currentdeviceindex();
 qint32 ls_closedevice();
 qint32 ls_opendevicebyindex(qint32 index);
 qint32 ls_opendevicebyserial(char* serial_num);
 qint32 ls_getpipe(void* lpbuffer, qint32 numberbytes);
 qint32 ls_waitforpipe(unsigned long timeout);
 qint32 ls_waitforpipecount(qint32 nCount, qint32 &nAvailable, unsigned long timeout);
 qint32 ls_setpacketlength(qint32 packetlen);
 quint32 ls_getfps();
 const char* ls_geterrorstring(int ierr);

 qint32 ls_setmuxchannel(quint8 ucmux, quint32 timeout);
 qint32 ls_getmuxchannel(qint8 &cmux, quint32 timeout);

 qint32 ls_readi2c_ext(quint8 i2caddr, void* lpbuffer, quint16 &wlength, quint32 timeout);
 qint32 ls_writei2c_ext(quint8 i2caddr, void* lpbuffer, quint16 wlength, quint32 timeout);
 qint32 ls_readi2c(quint8 i2caddr, void* lpbuffer, quint16 &wlength, quint32 timeout);
 qint32 ls_writei2c(quint8 i2caddr, void* lpbuffer, quint16 wlength, quint32 timeout);

 qint32 ls_i2cread1byte(quint8 i2caddr, quint8 i2creg, quint8 &ucvalue, quint32 timeout);
 qint32 ls_i2cread2bytes(quint8 i2caddr, quint8 i2creg, quint16 &wvalue, quint32 timeout);
 qint32 ls_i2cread4bytes(quint8 i2caddr, quint8 i2creg, quint32 &dwvalue, quint32 timeout);

 qint32 ls_i2cwrite1byte(quint8 i2caddr, quint8 i2creg, quint8 ucvalue, quint32 timeout);
 qint32 ls_i2cwrite2bytes(quint8 i2caddr, quint8 i2creg, quint16 wvalue, quint32 timeout);
 qint32 ls_i2cwrite4bytes(quint8 i2caddr, quint8 i2creg, quint32 dwvalue, quint32 timeout);

 qint32 ls_i2cwritecmd(quint8 i2caddr, quint8 i2ccmd, quint32 timeout);

 qint32 ls_setadcbias(quint8 addr, quint16 wbias, quint32 timeout);
 qint32 ls_getadcbias(quint8 addr, quint16 &wbias, quint32 timeout);

 qint32 ls_getadcvref(quint8 addr, quint8 &ucvref, quint32 timeout);
 qint32 ls_getadcgain(quint8 addr, quint8 &ucgain, quint32 timeout);
 qint32 ls_getadcoffset(quint8 addr, quint16 &woffset, quint32 timeout);
 qint32 ls_setadcvref(quint8 addr, quint8 ucvref, quint32 timeout);
 qint32 ls_setadcgain(quint8 addr, quint8 ucgain, quint32 timeout);
 qint32 ls_setadcoffset(quint8 addr, quint16 woffset, quint32 timeout);

 qint32 ls_gethw1id(quint8 addr, quint16 &wId, quint32 timeout);
 qint32 ls_gethw1version(quint8 addr, quint16 &wversion, quint32 timeout);
 qint32 ls_gethw2version(quint8 addr, quint16 &wversion, quint32 timeout);
 qint32 ls_getgainmult(quint8 addr, quint16 &wMult, quint32 timeout);
 qint32 ls_getgaindiv(quint8 addr,quint16 &wDiv, quint32 timeout);

 qint32 ls_hw_reset(quint8 addr, quint32 timeout);
 qint32 ls_suspend(quint8 addr, quint32 timeout);
 qint32 ls_resume(quint8 addr, quint32 timeout);
 qint32 ls_updateparam(quint8 addr, quint32 timeout);
 qint32 ls_setstate(quint8 addr, quint8 ucstate, quint32 timeout);
 qint32 ls_setmodeconfig(quint8 addr, quint8 ucconfig, quint32 timeout);
 qint32 ls_setifconfig(quint8 addr, quint8 ucconfig, quint32 timeout);
 qint32 ls_setstpulse(quint8 addr, quint32 dwhigh, quint32 dwlow, quint32 timeout);
 qint32 ls_setsthigh(quint8 addr, quint32 dwhigh, quint32 timeout);
 qint32 ls_setstlow(quint8 addr, quint32 dwlow, quint32 timeout);
 qint32 ls_setlinesperframe(quint8 addr, quint16 wlines, quint32 timeout);
 qint32 ls_setquadcount(quint8 addr, quint32 dwcount, quint32 timeout);
 qint32 ls_setsofttriggertime(quint8 addr, quint32 dwtime, quint32 timeout);
 qint32 ls_settriggerdelay(quint8 addr, quint32 dwdelay, quint32 timeout);
 qint32 ls_settriggerwidth(quint8 addr, quint32 dwwidth, quint32 timeout);
 qint32 ls_setpixelcount(quint8 addr, quint16 wcount, quint32 timeout);
 qint32 ls_setedgedelay(quint8 addr, quint8 ucedges, quint32 timeout);
 qint32 ls_setslaveaddress(quint8 addr, quint8 newaddr, quint32 timeout);
 qint32 ls_saveslaveaddress(quint8 addr, quint32 timeout);

 qint32 ls_savesettings(quint8 addr, quint32 timeout);
 qint32 ls_reloadsettings(quint8 addr, quint32 timeout);
 qint32 ls_resetsettings(quint8 addr, quint32 timeout);

 qint32 ls_getctgversion(quint8 addr, quint16 &wversion, quint32 timeout);
 qint32 ls_getmcuversion(quint8 addr, quint16 &wversion, quint32 timeout);
 qint32 ls_getctgstate(quint8 addr, quint8 &ucstate, quint32 timeout);
 qint32 ls_getstate(quint8 addr, quint8 &ucstate, quint32 timeout);
 qint32 ls_getmodeconfig(quint8 addr, quint8 &ucconfig, quint32 timeout);
 qint32 ls_getifconfig(quint8 addr, quint8 &ucconfig, quint32 timeout);
 qint32 ls_getstpulse(quint8 addr, quint32 &dwhigh, quint32 &dwlow, quint32 timeout);
 qint32 ls_getsthigh(quint8 addr, quint32 &dwhigh, quint32 timeout);
 qint32 ls_getstlow(quint8 addr, quint32 &dwlow, quint32 timeout);
 qint32 ls_getlinesperframe(quint8 addr, quint16 &wlines, quint32 timeout);
 qint32 ls_getquadcount(quint8 addr, quint32 &dwcount, quint32 timeout);
 qint32 ls_getsofttriggertime(quint8 addr, quint32 &dwtime, quint32 timeout);
 qint32 ls_gettriggerdelay(quint8 addr, quint32 &dwdelay, quint32 timeout);
 qint32 ls_gettriggerwidth(quint8 addr, quint32 &dwwidth, quint32 timeout);

 qint32 ls_getpixelcount(quint8 addr, quint16 &wcount, quint32 timeout);
 qint32 ls_getedgedelay(quint8 addr, quint8 &ucedges, quint32 timeout);
 qint32 ls_getslaveaddress(quint8 addr, quint8 &newaddr, quint32 timeout);
 qint32 ls_getinitstatus(quint8 addr, quint8 &ucstatus, quint32 timeout);
 qint32 ls_getcomresult(quint8 addr, quint8 &ucresult, quint32 timeout);

 qint32 ls_setcfg1(quint8 uccfg1, quint32 timeout);
 qint32 ls_getcfg1(quint8 &uccfg1, quint32 timeout);
 qint32 ls_getpacketlength(qint32 &packetlen, quint32 timeout);
 qint32 ls_iscustomfirmware(quint32 &dwcustom, quint32 timeout);

#ifdef __cplusplus
}                       /* End of extern "C" */
#endif

#endif // USBLISMPI26_H
